<?php
require_once(__DIR__ . '/../../../../../../config.php');
require_once('/home/tupointp/public_html/facturacion/production/conexion.php');
date_default_timezone_set('America/Lima');
require_once '../../../lib/PHPExcel/PHPExcel.php';
$objPHPExcel = new PHPExcel();

// Agregar datos al archivo Excel
$objPHPExcel->setActiveSheetIndex(0);

// Establecer el ancho de las columnas
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(50); // Ancho de la columna A y B fusionadas
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20); // Ancho de la columna C
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20); // Ancho de la columna D
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20); // Ancho de la columna E

// Establecer estilos para las celdas utilizadas (negrita y bordes)
$style = array(
    'font' => array(
        'bold' => true,
    ),
    'borders' => array(
        'outline' => array(
            'style' => PHPExcel_Style_Border::BORDER_THICK,
            'color' => array('rgb' => '000000'),
        ),
        'inside' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
            'color' => array('rgb' => '000000'),
        ),
    ),
);

// Establecer estilo para alinear a la izquierda
$leftAlignmentStyle = array(
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
    ),
);

// Fusionar celdas para el encabezado
$objPHPExcel->getActiveSheet()->mergeCells('A1:B1');

// Escribir los encabezados fusionados
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'Nombre Producto');
$objPHPExcel->getActiveSheet()->setCellValue('C1', 'Total Cantidad');
$objPHPExcel->getActiveSheet()->setCellValue('D1', 'Costo');
$objPHPExcel->getActiveSheet()->setCellValue('E1', 'Subtotal Ventas');
$sql = "SELECT stock.id_stock, producto.nombre_producto, tipo.detalle_tipo, SUM(movimiento.cantidad) AS total_cantidad, movimiento.costo, SUM(movimiento.cantidad * movimiento.costo) AS sub_total_ventas FROM movimiento JOIN stock ON movimiento.id_stock = stock.id_stock JOIN producto ON producto.id_producto = stock.id_producto JOIN stock_tienda ON movimiento.id_stock_tienda = stock_tienda.id_stock_tienda JOIN familia ON stock.id_familia = familia.cod_familia JOIN tipo ON tipo.id_tipo = stock.id_tipo WHERE movimiento.fecha BETWEEN '{$_GET['fecha']}' AND '{$_GET['fecha1']}' GROUP BY movimiento.id_stock";
$result = mysql_query($sql, $conexion);
$row = 2; 
$total=0;
while ($datos = mysql_fetch_array($result)) {
    // Fusionar celdas para nombre_producto y detalle_tipo
    $objPHPExcel->getActiveSheet()->mergeCells('A'.$row.':B'.$row);
    // Escribir datos en la celda fusionada
    $objPHPExcel->getActiveSheet()->setCellValue('A'.$row, $datos['nombre_producto'].' - '.$datos['detalle_tipo']);
    // Escribir datos en las celdas restantes
    $objPHPExcel->getActiveSheet()->setCellValue('C'.$row, $datos['total_cantidad']);
    $objPHPExcel->getActiveSheet()->setCellValue('D'.$row, 'S/.'.number_format($datos['costo'],2,'.',''));
    $objPHPExcel->getActiveSheet()->setCellValue('E'.$row, 'S/.'.number_format($datos['sub_total_ventas'],2,'.',''));
    $row++;
    $total=$datos['sub_total_ventas']+$total;
    
}
$objPHPExcel->getActiveSheet()->mergeCells('A'.$row.':'.'D'.$row);
$objPHPExcel->getActiveSheet()->setCellValue('A'.$row, 'TOTAL:');
$objPHPExcel->getActiveSheet()->setCellValue('E'.$row, 'S/.'.number_format($total,2,'.',''));
// Aplicar estilo a todas las celdas en uso
$highestRow = $objPHPExcel->getActiveSheet()->getHighestRow();
$highestColumn = $objPHPExcel->getActiveSheet()->getHighestColumn();
$range = 'A1:'.$highestColumn.$highestRow;
$objPHPExcel->getActiveSheet()->getStyle($range)->applyFromArray($style);

// Aplicar alineación a la izquierda para la columna C
$rangeC = 'C2:C'.$highestRow;
$objPHPExcel->getActiveSheet()->getStyle($rangeC)->applyFromArray($leftAlignmentStyle);

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="ReportedeVentas.xlsx"');
header('Cache-Control: max-age=0');
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');

exit;
?>